/*******************************************************************
*
*  DESCRIPTION: Atomic Model Sonar1
*
*  AUTHOR: Dieynaba Alpha Tall
*
*  EMAIL: alphadieynaba@yahoo.fr
*
*  DATE: 07/08/2009
*******************************************************************/

/** include files **/
#include <math.h>            // fabs( ... )
#include <stdlib.h>
#include "LightSensor.h"  // base header
#include "message.h"       // InternalMessage ....
#include "mainsimu.h"      // class MainSimulator
#include "strutil.h"       // str2float( ... )
#include "commonH.h"

/*******************************************************************
* Function Name: LightSensor
* Description: constructor
********************************************************************/
LightSensor::LightSensor( const std::string &name ) : Atomic( name )
, ls_light_in( addInputPort( "ls_light_in" ) )
, ls_start_in( addInputPort( "ls_start_in" ) )
, ls_light_out( addOutputPort( "ls_light_out" ) )
, lsTxTime (00,00,00,10)
{
	std::string timepreparation( MainSimulator::Instance().getParameter( description(), "lsTxTime" ) ) ;
//test
	if (timepreparation !="") lsTxTime = timepreparation;

	//MainSimulator::Instance().Spin_Motor_Clockwise(30);

	cout<<"lsTxTime="<<lsTxTime<<"\n";
}

/*******************************************************************
* Function Name: Sonar1::initFunction()
* Description: Initialization Function
********************************************************************/
Model &LightSensor::initFunction()
{
	state = IDLE;
	passivate();
	return *this ;
}

/*******************************************************************
* Function Name: Sonar1::externalFunction()
* Description: External Function Sonar1
********************************************************************/
Model &LightSensor::externalFunction( const ExternalMessage &msg )
{
	cout << "--> In LS ExtFunc() / state= " << state;
	
	if (msg.port() == ls_start_in) {
		
		cout << "/ port= ls_start_in / value= " << static_cast <int> (msg.value());
		
		if (state == IDLE && msg.value()== START_PROC) {
			state = DETECTING;
			passivate();
		}
		else if (msg.value()== STOP_PROC) {
			state = IDLE;
			passivate();
		}
		
	} else if (msg.port() == ls_light_in) {
		
		cout << "/ port= ls_light_in, value= " << static_cast <int> (msg.value());
		
		if (state == DETECTING)
		{
			state = TX_DATA;
			light_input = static_cast <int> (msg.value());
			holdIn(Atomic::active, lsTxTime);
		}
	}
	
	cout << "/ new state= " << state << "\n";
	
	return *this;
}

/*******************************************************************
* Function Name: Sonar1::internalFunction()
* Description: Internal Function Sonar1
********************************************************************/
Model &LightSensor::internalFunction( const InternalMessage & )
{
	cout << "<----- In LS IntFunc() / state= " << state;
	
	if(state==TX_DATA){
		state=DETECTING;
		passivate();
	}
	
	cout << "/ new state= " << state << "\n";

	return *this;
}

/*******************************************************************
* Function Name: Sonar1::outputFunction()
* Description: Output function Sonar1 - writes info about time and events
********************************************************************/
Model &LightSensor::outputFunction( const InternalMessage &msg )
{
	cout << "<----- In LS OutFunc() / state= " << state;
	
	if (state == TX_DATA){
		sendOutput( msg.time(), ls_light_out, light_input) ;//something found
		
		cout << "/ sent " << light_input << " to ls_light_out\n";
	}
	
	return *this ;
}

LightSensor::~LightSensor()
{
	//MainSimulator::Instance().Spin_Motor_Stop();
}
